# Delimited Presskit

## TL;DR
Delimited is a lightweight, fast, and minimal CSV/TSV editor for macOS, designed for quick file browsing and essential table editing without the bloat of traditional spreadsheet apps. It supports intuitive copy/paste, flexible header management, and remembers table settings using extended file attributes. With a clean UI that integrates seamlessly into macOS, Delimited offers a refined alternative to other CSV editors.


## How it works

### Fast File Browsing
Delimited opens CSV and TSV files almost instantly, on par with text editors. Unlike spreadsheet apps that often require cloud uploads or proprietary conversions, Delimited focuses on speed and efficiency. While spreadsheets offer extensive features, I often just need to browse a CSV, make quick edits, and move on—and that’s exactly what Delimited is good at.

### Essential Table Editing
Delimited provides all the fundamental table editing capabilities:

- Add, move, and remove columns and rows. Shortcuts are available to speed up your workflow.
- Edit cells with proper text wrapping for multiline content. This also makes the table easier to read compared to text editors.
- View essential table stats, including table dimensions, selected rows/columns, and the currently edited cell

### Intuitive Copy & Paste
Delimited uses plain-text copy and paste, making it easy to extract a subset of data and transfer it to another application without any special formatting or conversion.

### Flexible Header Management
Not all tables have headers, so Delimited allows you to choose whether the first row is interpreted as a header or as data. You can also toggle this setting while editing.

### Remembered Preferences
Delimited utilizes extended file attributes to store table properties. This means that when you reopen a file, it retains settings such as whether the table has a header.

### Designed for macOS
Delimited was built with macOS in mind, focusing on a clean, modern interface that integrates seamlessly with the system. Many CSV editors offer a broad range of features, but I wanted something that prioritized clarity, ease of use and (if I may say so) a good looking dock icon.

### Why I Made Delimited
After nearly a decade of C++ programming, I decided it would be fun to learn a more modern programming language. I’ve always been drawn to UI and UX design, and I was curious about creating a macOS app that felt intuitive and lightweight - all this led me to Swift.
CSV editing stood out because I've never been totally satisfied with the options available: spreadsheet apps offer extensive features but can feel slow for quick edits, while text editors lack proper formatting. I saw an opportunity to design something simple, efficient, and visually cohesive with macOS. Delimited is a tool that balances functionality with a clean, uncluttered experience.


## Key features
- **Essential Table Editing:** Add, move, and remove columns and rows.
- **Field Editing:** Edit individual cells with proper text wrapping for multiline content.
- **Header Management:** Toggle whether the first line in the file should be interpeted as a header or not.
- **Table Statistics:** View essential data like table dimensions, selected rows/columns, and the currently edited cell.
- **Plain-Text Copy & Paste:** Easily extract and share data between applications without unwanted formatting.
- **Fast Performance:** Opens files quickly, on par with text editors.
- **No Cloud or Proprietary Formats:** Delimited keeps your files local and adheres to the [RFC 4180](https://www.ietf.org/rfc/rfc4180.txt) format. No forced uploads, no proprietary conversions.
- **macOS Native Design:** A clean, refined UI with custom-designed icons that feel right at home on macOS.


## Pricing
Delimited is available on the App Store for $3.99. You only need to purchase it once on the App Store, there are no other in-app purchases or subscriptions available.


## System requirements
Delimited is available on macOS 14.5 and later.


## Release information,
Delimited was released on the macOS app store on the 24th of January 2025


## Links
- App Store link: https://apps.apple.com/us/app/delimited/id6740486871
- App link: https://delimited.app
- Author link: https://willemkempers.nl